/************************************************************************
 *
 * \file: mspin_demo_testbed.cpp
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: mySPIN - Demo application
 *
 * \author: Bui Le Thuan / RBVH/ENG2 / Thuan.BuiLe@vn.bosch.com
 *
 * \copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#include "mspin_demo_testbed.h"
#include <mspin_logging.h>


Testbed::Testbed()
{
    m_myspin_testbed_mode = false;
    m_myspin_g_main_loop_ctx = NULL;
    m_myspin_layer_id = 1;
    m_myspin_surface_id = -1;
    m_myspin_state = TBA_STATE_INIT;

    m_myspin_is_AndroidPhone = FALSE;
    m_myspin_android_phone_disconnect = FALSE;
    m_myspin_apple_phone_disconnect = FALSE;
}

Testbed::~Testbed()
{
    // Don't do anything
}

void Testbed::setTestbedMode(bool inTestbedMode)
{
    m_myspin_testbed_mode = inTestbedMode;
}

bool Testbed::getTestbedMode()
{
    return m_myspin_testbed_mode;
}

int Testbed::getSurfaceID()
{
    return m_myspin_surface_id;
}

int Testbed::getLayerID()
{
    return m_myspin_layer_id;
}

void Testbed::setState(int inState)
{
    m_myspin_state = inState;
}

int Testbed::getState()
{
    return m_myspin_state;
}

void Testbed::setConnectedAndroidPhone(bool inAndroidPhone)
{
    m_myspin_is_AndroidPhone = inAndroidPhone;
}

bool Testbed::getConnectedAndroidPhone()
{
    return m_myspin_is_AndroidPhone;
}

void Testbed::setAndroidPhoneDisconnectionStatus(bool inAndroidPhoneDisconnection)
{
    m_myspin_android_phone_disconnect = inAndroidPhoneDisconnection;
}

bool Testbed::getAndroidPhoneDisconnectionStatus()
{
    return m_myspin_android_phone_disconnect;
}

void Testbed::setApplePhoneDisconnectionStatus(bool inApplePhoneDisconnection)
{
    m_myspin_apple_phone_disconnect = inApplePhoneDisconnection;
}

bool Testbed::getApplePhoneDisconnectionStatus()
{
    return m_myspin_apple_phone_disconnect;
}

void Testbed::adit_testbed_init()
{
    m_myspin_surface_id = 254;

    const tba_callbacks_t callbacks_TB =
    {
            .state_changed_cb = state_changed_TB,
            .entering_shutdown_cb = entering_shutdown_TB,
            .waking_up_cb = waking_up_TB,
            .log_event_cb = log_event_TB,
            .surface_id_received_cb = surface_id_received_TB,
            .surface_id_invalid_cb = surface_id_invalid_TB
    };

    //init application framework
    m_myspin_g_main_loop_ctx = g_main_loop_new(NULL, FALSE);

    if (libtestbedapp_init(FALSE,"com.adit.testbed.myspinApp",TBA_LOGLEVEL_ERROR,20000,&callbacks_TB, this) != TBA_RESULT_OK)
    {
        mspin_log_printLn(eMspinVerbosityError, "Testbed library initialization failed.\n");
    }
    else
    {
        mspin_log_printLn(eMspinVerbosityInfo, "Initialized of Testbed App.\n");
    }
}

void Testbed::adit_testbed_run()
{
    mspin_log_printLn(eMspinVerbosityInfo, "Entering mainloop of mySPIN Testbed App.\n");
    g_main_loop_run(m_myspin_g_main_loop_ctx);
    mspin_log_printLn(eMspinVerbosityInfo, "Shutting down mySPIN Testbed App...\n");
}

void Testbed::adit_testbed_deinit()
{
    libtestbedapp_deinit();
    if (m_myspin_g_main_loop_ctx!=NULL)
    {
        g_main_loop_quit(m_myspin_g_main_loop_ctx);
    }
    mspin_log_printLn(eMspinVerbosityInfo, "Deinit of Testbed App.\n");
}

void Testbed::surface_id_received_TB(unsigned int surface_id, void *user_data)
{
    (void)user_data;
    (void)surface_id;
}

void Testbed::surface_id_invalid_TB(unsigned int surface_id, void *user_data)
{
    (void)user_data;
    mspin_log_printLn(eMspinVerbosityInfo,"Surface id now invalid: %u", surface_id);
}

void Testbed::state_changed_TB(tba_app_state_t previous_state, tba_app_state_t new_state, void *user_data)
{
    (void)previous_state;

    Testbed* tbInstance = (Testbed*) user_data;
    tbInstance->m_myspin_state = new_state;
}

bool Testbed::entering_shutdown_TB(int request_id, void *user_data)
{
    (void)user_data;
    (void)request_id;
    return FALSE;
}

bool Testbed::waking_up_TB(tba_app_state_t recent_active_state, tba_app_state_t *targeted_state, int request_id, void *user_data)
{
    (void)user_data;
    (void)request_id;
    (void)*targeted_state;
    mspin_log_printLn(eMspinVerbosityInfo,"Application is requested to wake up into state: %d",recent_active_state);
    return TRUE;
}

void Testbed::log_event_TB(tba_loglevel_t level, const char *msg, void *user_data)
{
    (void)user_data;
    if (level==TBA_LOGLEVEL_ERROR)
        mspin_log_printLn(eMspinVerbosityError,"ERROR : %s", msg);
    else
        mspin_log_printLn(eMspinVerbosityInfo,"%s", msg);
}


void Testbed::adit_testbed_available()
{
    libtestbedapp_service_available();
}

void Testbed::adit_testbed_background()
{
    libtestbedapp_send_to_background();
}

void Testbed::adit_testbed_foreground()
{
    libtestbedapp_send_to_foreground();
}

void Testbed::adit_testbed_lost()
{
    libtestbedapp_service_lost();
}
